package demo.module;

import java.awt.Panel;

import netsdk.lib.ToolKits;
import netsdk.struct.LPNET_SDK_CLIENTINFO;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;

/**
 * 实时预览接口实现
 * 主要有 ：开始拉流、停止拉流功能
 */
public class RealPlayModule {	
	/**
	 * \if ENGLISH_LANG
	 * Start RealPlay
	 * \else
	 * 开始预览
	 * \endif
	 */
	public static NativeLong startRealPlay(int channel, int stream, Panel realPlayWindow) {
		
		LPNET_SDK_CLIENTINFO.ByReference lpClientInfo = new LPNET_SDK_CLIENTINFO.ByReference();
		lpClientInfo.lChannel = channel;
		lpClientInfo.streamType = stream;
		lpClientInfo.hPlayWnd = Native.getComponentPointer(realPlayWindow);
		lpClientInfo.bNoDecode = 0;
		NativeLong m_hPlayHandle = LoginModule.netsdk.NET_SDK_LivePlay(LoginModule.m_hLoginHandle, lpClientInfo, null, null);
	
	    if(m_hPlayHandle.intValue() < 1) {
	  	    System.err.println("开始实时监视失败，错误码" + ToolKits.getErrorCodePrint());
	    } else {
	  	    System.out.println("Success to start realplay"); 
	    }
	    
	    return m_hPlayHandle;
	} 
	
	/**
	 * \if ENGLISH_LANG
	 * Start RealPlay
	 * \else
	 * 停止预览
	 * \endif
	 */
	public static void stopRealPlay(NativeLong m_hPlayHandle) {
		if(m_hPlayHandle.longValue() == 0) {
			return;
		}
		
		boolean bRet = LoginModule.netsdk.NET_SDK_StopLivePlay(m_hPlayHandle);
		if(bRet) {
			m_hPlayHandle.setValue(0);
		}
	}
}
